//+------------------------------------------------------------------+
//|                                      Multi pair Williams % range |
//|                                                           mladen |
//+------------------------------------------------------------------+
#property copyright "mladen"
#property link      "mladenfx@gmail.com"

#property  indicator_separate_window
#property  indicator_buffers     8
#property  indicator_minimum  -100
#property  indicator_maximum     0
#property  indicator_color1  C'255,0,255'
#property  indicator_color2  C'208,0,208'
#property  indicator_color3  C'164,0,164'
#property  indicator_color4  C'128,0,128'
#property  indicator_color5  C'128,0,164'
#property  indicator_color6  C'128,0,208'
#property  indicator_color7  DimGray
#property  indicator_color8  DimGray
#property  indicator_style7  STYLE_DOT
#property  indicator_style8  STYLE_DOT

//
//
//
//
//

extern string    pairs          = "EURUSD;GBPUSD;USDCAD";
extern int       barsPerPair    = 70;
extern string    WPRperiods     = "18;48;96";
extern int       levelUp        = -10;
extern int       levelDown      = -90;
extern string    text           = "color";
extern color     textColor      = Silver;
extern color     backColor      = C'48,48,48';
extern int       separatorWidth = 6;

//---- buffers
//
//
//
//

double   ind_buffer1[];
double   ind_buffer2[];
double   ind_buffer3[];
double   ind_buffer4[];
double   ind_buffer5[];
double   ind_buffer6[];
double   ind_buffer7[];
double   ind_buffer8[];

//
//
//
//
//

string   aPairs[];
int      nPeriods[];
string   shortName;
int      window;  



//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+

int init()
{
   SetIndexBuffer(0,ind_buffer1);
   SetIndexBuffer(1,ind_buffer2);
   SetIndexBuffer(2,ind_buffer3);
   SetIndexBuffer(3,ind_buffer4);
   SetIndexBuffer(4,ind_buffer5);
   SetIndexBuffer(5,ind_buffer6);
   SetIndexBuffer(6,ind_buffer7);
   SetIndexBuffer(7,ind_buffer8);

   //
   //
   //
   //
   //

      WPRperiods = StringUpperCase(StringTrimLeft(StringTrimRight(WPRperiods)));
      if (StringSubstr(WPRperiods,StringLen(WPRperiods),1) != ";")
                       WPRperiods = StringConcatenate(WPRperiods,";");

         //
         //
         //
         //
         //                                   
            
         int p = 0;
         int s = 0;
         int i = StringFind(WPRperiods,";",s);
            while (i > 0)
            {
               p = StrToInteger(StringSubstr(WPRperiods,s,i-s));
               if (p > 0)
                  {
                     ArrayResize(nPeriods,ArraySize(nPeriods)+1);
                                 nPeriods[ArraySize(nPeriods)-1] = p;
                  }
                  s = i + 1;
                  i = StringFind(WPRperiods,";",s);
            }

            //
            //
            //    adjust display
            //
            //
            
            for (i=0;i<ArraySize(nPeriods);i++)
               {
                  SetIndexLabel(i,"%R "+nPeriods[i]);
                  SetIndexStyle(i,DRAW_LINE);
               }
            for(;i<8;i++)               
               {
                           SetIndexLabel(i,NULL);
                   if(i<6) SetIndexStyle(i,DRAW_NONE);
               }

   //
   //
   //
   //
   //

      pairs = StringUpperCase(StringTrimLeft(StringTrimRight(pairs)));
      if (StringSubstr(pairs,StringLen(pairs),1) != ";")
                       pairs = StringConcatenate(pairs,";");

         //
         //
         //
         //
         //                                   
            
         s = 0;
         i = StringFind(pairs,";",s);
         string current;
         string temp;
            while (i > 0)
            {
               if (IsMini())
                     current = StringSubstr(pairs,s,i-s)+"m";
               else  current = StringSubstr(pairs,s,i-s);
               if (iClose(current,0,0) > 0)
                  {
                     ArrayResize(aPairs,ArraySize(aPairs)+1);
                                 aPairs[ArraySize(aPairs)-1] = current;
                                 if (current == Symbol())
                                 {
                                       temp      = aPairs[0];
                                       aPairs[0] = current;
                                       aPairs[ArraySize(aPairs)-1] = temp;
                                 }                                       
                  }
                  s = i + 1;
                  i = StringFind(pairs,";",s);
            }

      //
      //
      //
      //
      //
 
      separatorWidth = MathMax(separatorWidth,4);
      shortName = MakeUniqueName("Multi %R "," ("+WPRperiods+")");
      IndicatorShortName(shortName);
   return(0);
}


int deinit()
{
   for (int i = 0; i < ArraySize(aPairs); i++) { 
         ObjectDelete(shortName+i);
         ObjectDelete(shortName+i+i);
      }         
   return(0);
}


//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
{
   int    limit = ArraySize(aPairs);
   int    i,k;
   
   //
   //
   //
   //
   //

         window = WindowFind(shortName);  
         k = 0; for (i=0; i<limit; i++) k = calculateWPR(aPairs[i],barsPerPair,k,i);

   //
   //
   //
   //
   //

   for (i=0;i<indicator_buffers;i++) SetIndexDrawBegin(i,Bars-k);
   return(0);
}


//+------------------------------------------------------------------+
//+                                                                  +
//+------------------------------------------------------------------+

int calculateWPR(string symbol,int limit,int shift,int element)
{
   bool   signalCrossing = false;
   double max;
   int    i;

   //
   //
   //
   //
   //

   for(i=0; i<limit; i++) {
      if(nPeriods[0]>0) ind_buffer1[shift+i]=iWPR(symbol,0,nPeriods[0],i);
      if(nPeriods[1]>0) ind_buffer2[shift+i]=iWPR(symbol,0,nPeriods[1],i);
      if(nPeriods[2]>0) ind_buffer3[shift+i]=iWPR(symbol,0,nPeriods[2],i);
      if(nPeriods[3]>0) ind_buffer4[shift+i]=iWPR(symbol,0,nPeriods[3],i);
      if(nPeriods[4]>0) ind_buffer5[shift+i]=iWPR(symbol,0,nPeriods[4],i);
      if(nPeriods[5]>0) ind_buffer6[shift+i]=iWPR(symbol,0,nPeriods[5],i);
                        ind_buffer7[shift+i]=levelUp;
                        ind_buffer8[shift+i]=levelDown;
   }            

   
   //
   //
   //
   //
   //

   for (i=0;i<separatorWidth;i++) {
         ind_buffer1[shift+limit+i] = EMPTY_VALUE;                     
         ind_buffer2[shift+limit+i] = EMPTY_VALUE;                     
         ind_buffer3[shift+limit+i] = EMPTY_VALUE;                     
         ind_buffer4[shift+limit+i] = EMPTY_VALUE;                     
         ind_buffer5[shift+limit+i] = EMPTY_VALUE;                     
         ind_buffer6[shift+limit+i] = EMPTY_VALUE;                     
         ind_buffer7[shift+limit+i] = EMPTY_VALUE;                     
         ind_buffer8[shift+limit+i] = EMPTY_VALUE;                     
      }         

   //
   //
   //
   //
   //
   
   createLabel(symbol,element,shift+limit+separatorWidth-2,signalCrossing);
   return(shift+limit+separatorWidth-1);
}



//+------------------------------------------------------------------+
//+                                                                  +
//+------------------------------------------------------------------+
//
//
//
//
//

void createLabel(string symbol,int element, int shift, bool signalCrossing)
{
   string name   = shortName+element;
   double price1 =    0;
   double price2 = -100;
   
   //
   //
   //
   //
   //
   
   if (ObjectFind(name) == -1)
      {
         ObjectCreate(name,OBJ_TEXT,window,0,0);
         ObjectSet(name,OBJPROP_ANGLE,90);
         ObjectSetText(name,symbol);
      }
      ObjectSet(name,OBJPROP_TIME1 ,Time[shift]);
      ObjectSet(name,OBJPROP_PRICE1,(price1+price2)/2);
      if (signalCrossing)
           ObjectSet(name,OBJPROP_COLOR,Gold);
      else ObjectSet(name,OBJPROP_COLOR,textColor);

   //
   //
   //
   //
   //

 
   name = shortName+element+element;
   if (ObjectFind(name) == -1)
      {
         ObjectCreate(name,OBJ_RECTANGLE,window,0,0,0,0);
         ObjectSet(name,OBJPROP_COLOR,backColor);
      }         
      ObjectSet(name,OBJPROP_TIME1,Time[shift]);
      ObjectSet(name,OBJPROP_PRICE1,price1);
      ObjectSet(name,OBJPROP_TIME2,Time[shift-(separatorWidth-2)]);
      ObjectSet(name,OBJPROP_PRICE2,price2);
}

//+------------------------------------------------------------------+
//+                                                                  +
//+------------------------------------------------------------------+
//
//
//
//
//


string StringUpperCase(string str)
{
   string   s = str;
   int      lenght = StringLen(str) - 1;
   int      char;
   
   while(lenght >= 0)
      {
         char = StringGetChar(s, lenght);
         
         //
         //
         //
         //
         //
         
         if((char > 96 && char < 123) || (char > 223 && char < 256))
                  s = StringSetChar(s, lenght, char - 32);
          else 
              if(char > -33 && char < 0)
                  s = StringSetChar(s, lenght, char + 224);
                  
         //
         //
         //
         //
         //
                                 
         lenght--;
   }
   
   //
   //
   //
   //
   //
   
   return(s);
}

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
//
//
//
//
//

string MakeUniqueName(string first, string rest)
{
   string result = first+(MathRand()%1001)+rest;

   while (WindowFind(result)> 0)
          result = first+(MathRand()%1001)+rest;
   return(result);
}
bool IsMini()
{
   if (StringFind(Symbol(),"m") > -1)
         return(true);
   else  return(false);    
}